varying vec2 f_texcoord;

uniform sampler2D texture_frame;
uniform sampler2D texture_occlusion;

#define SSAO_STRENGTH 0.30

void main(void)
{
	vec4 colorFrame = texture2D(texture_frame, f_texcoord);
	float occ = texture2D(texture_occlusion, f_texcoord).r;

	float multOcc = 1.0 - (occ*SSAO_STRENGTH);

	const vec3 shadowColor = vec3(50.0/256.0, 0.0/256.0, 100.0/256.0);
	vec3 multColor = mix(shadowColor, vec3(1.0), multOcc);

	gl_FragColor = vec4(colorFrame.rgb*multColor, 1.0);
}

